%% reading data
clear all
[FileNames,PathName,FilterIndex] = uigetfile('*.xls;*.xlsx','Select all AverageSpectrum files you want to combine','MultiSelect', 'on');
%% load first file and prompt for change of frame time or pixel size...
for file=1:length(FileNames)
FileName=FileNames{file};
[num,txt] = xlsread([PathName FileName],'Modes');
ind=find(num(:,2)==max(num(:,2)));
AllMainModes(file,:)=num(ind,:);
names{file}=FileName(1:end-4);
end

T=table(AllMainModes(:,1),AllMainModes(:,2),'VariableNames',{'CBF','Amplitude'},'RowNames',names);
writetable(T,[PathName 'FirstAmplitudeStacked.xlsx'],'WriteRowNames',true);